#![forbid(unsafe_code)]
#![deny(missing_docs)]
#![deny(clippy::all)]
// #![warn(clippy::pedantic)]
//! # persist-es
//!
//! > Common persistence logic used for database-backed event stores for [cqrs-es.](https://crates.io/crates/cqrs-es).
//!
// #![doc = include_str!("../README.md")]
mod context;
mod error;
mod event_store;
mod queries;
mod repository;
mod serialized_event;
mod snapshot_store;
mod upcaster;

pub use context::{EventStoreAggregateContext, QueryContext, SnapshotStoreAggregateContext};
pub use error::PersistenceError;
pub use event_store::PersistedEventStore;
pub use queries::GenericQuery;
pub use repository::{PersistedEventRepository, ViewRepository};
pub use serialized_event::{SerializedEvent, SerializedSnapshot};
pub use snapshot_store::PersistedSnapshotStore;
pub use upcaster::{EventUpcaster, SemanticVersionEventUpcaster};
