#![forbid(unsafe_code)]
#![deny(missing_docs)]
#![deny(clippy::all)]
// #![warn(clippy::pedantic)]
//! # postgres-es
//!
//! > Common persistence logic used for database-backed event stores for [cqrs-es](https://crates.io/crates/persist-es).
//!
mod context;
mod error;
mod event_store;
mod queries;
mod repository;
mod snapshot_store;

pub use context::{EventStoreAggregateContext, QueryContext, SnapshotStoreAggregateContext};
pub use error::PersistenceError;
pub use event_store::PersistedEventStore;
pub use queries::GenericQuery;
pub use repository::{PersistedEventRepository, ViewRepository};
pub use snapshot_store::PersistedSnapshotStore;
