extern crate peroxide;
use peroxide::fuga::*;

#[test]
fn test_det() {
    let test_mat = ml_matrix(
        "0.19832 0.00439457 0.72102 0.902151 0.889423 0.820379;
        0.675846 0.33786 0.95276 0.123486 0.982328 0.493835;
        0.473623 0.114907 0.728475 0.398401 0.817148 0.562954;
        0.256825 0.889961 0.9725 0.0984108 0.1435 0.0820303;
        0.530138 0.718637 0.450948 0.27664 0.98232 0.925627;
        0.820478 0.0512247 0.757406 0.674419 0.128289 0.352762",
    );
    nearly_eq(test_mat.det(), 0.007304119459983581);
}

#[test]
fn test_det2() {
    let test_mat = ml_matrix(
        "1.0 0.0 -0.0000000006883364201712421 0.0 0.0 0.0000000001064860147865378;
        -5598.076212382752 1.0 -0.0000006638966446777877 866.0254039436925 0.0 0.00000010270516835983237;
        8.9999151651235 0.0 1.0000000017097728 -1.3922917214121957 0.0 -0.0000000002645027823871779;
        0.0 0.0 -0.00000002065773795701977 1.0 0.0 -0.000000009587289550945372;
        -866.0254060025674 0.0 -0.00000533869292434282 -401.92378967612115 1.0 -0.0000024776960089120054;
        1.3922917247222075 0.0 0.000000013749056209635527 0.6461648381865064 0.0 1.000000006380959"
    );
    nearly_eq(test_mat.det(), 0.9999999915708137);
}
