# 🎲 perchance

A lightweight, quick, and easy-to-use library for generating and using randomness, designed for the most common use cases you find in games and geometry.

Note that `perchance` is **not** cryptographically secure and ***should not*** be used in contexts where security is a concern.

## Usage

`perchance` is a simple random number generation library, tuned for ease of use: create an instance of `PerchanceContext` and go.

```rust
let mut rng = perchance::PerchanceContext::new(seed);

let between_0_and_1 = rng.uniform_f32();
let dice_roll = rng.uniform_range_i32(1..=6);
let random_direction = rng.uniform_sphere_surface_vec3();
let thing_should_happen = rng.get_bool();

enum Event {
    Thing1,
    Thing2,
    Thing3,
}
let which_should_happen = rng.choose(&[Event::Thing1, Event::Thing2, Event::Thing3]);
```

You can also use the global `perchance::global()` if you have the `std` feature enabled:

```rust
// Seed the global context first. You may do so manually, or, on platforms that support it,
// obtain a seed to pass into it by calling `perchance::gen_time_seed()`.
perchance::seed_global(0x5F3759DF); // ;)

let mut rng = perchance::global();
let between_0_and_1 = rng.uniform_f32();
```

## Contributing

We welcome community contributions to this project.

Please read our [Contributor Guide](CONTRIBUTING.md) for more information on how to get started.

## License

Licensed under either of

* Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE) or <http://www.apache.org/licenses/LICENSE-2.0>)
* MIT license ([LICENSE-MIT](LICENSE-MIT) or <http://opensource.org/licenses/MIT>)

at your option.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in the work by you, as defined in the Apache-2.0 license, shall be dual licensed as above, without any additional terms or conditions.
