use perchance::PerchanceContext;

#[test]
#[rustfmt::skip] // easier copy/paste from the generation code
fn get_u32() {
    let mut rng = PerchanceContext::new(0x5F3759DF);
    let answers = [
        4266051443,
        4175272176,
        1912828164,
        2211017528,
        990643981, 
        3162509677,
        423848035, 
        2651690816,
        4139960315,
        310499900, 
    ];
    for answer in answers {
        let case = rng.get_u32();
        assert_eq!(case, answer);
    }
}

#[test]
#[rustfmt::skip] // easier copy/paste from the generation code
fn uniform_f32() {
    let mut rng = PerchanceContext::new(0x5F3759DF);
    let answers = [
        0.9932674,
        0.97213125, 
        0.44536495, 
        0.51479256, 
        0.23065221, 
        0.7363291,  
        0.09868479, 
        0.6173948,  
        0.9639095,  
        0.07229388, 
    ];
    for answer in answers {
        let case = rng.uniform_f32();
        assert_eq!(case, answer);
    }
}

#[test]
#[rustfmt::skip] // easier copy/paste from the generation code
fn uniform_range_i32() {
    let mut rng = PerchanceContext::new(0x5F3759DF);
    let answers = [
        4,
        1,
        5,
        1,
        6,
        6,
        4,
        1,
        4,
        5,
    ];
    for answer in answers {
        let case = rng.uniform_range_i32(1..=6);
        assert_eq!(case, answer);
    }
}

#[test]
#[rustfmt::skip] // easier copy/paste from the generation code
fn uniform_range_f32() {
    let mut rng = PerchanceContext::new(0x5F3759DF);
    let answers = [
        4.9596043,  
        4.8327875,  
        1.6721897,  
        2.0887554,  
        0.38391328, 
        3.4179745,  
        -0.40789127,
        2.7043688,  
        4.783457,   
        -0.56623673,
    ];
    for answer in answers {
        let case = rng.uniform_range_f32(-1.0..5.0);
        assert_eq!(case, answer);
    }
}
