# 🎲 perchance

A lightweight and easy-to-use library for generating random numbers, designed for the most common use cases you find in games and geometry.

## Usage

```rust
let mut rng = PerchanceContext::new(seed);
let dice = rng.uniform_range_i32(0..6);
let random_direction = rng.uniform_sphere_surface_vec3();
let between_0_and_1 = rng.uniform_f32();
```

You can also use the global `perchance::global()` (make sure to seed it
first!):

```rust
perchance::seed(applet().random_seed_value());
let between_0_and_1 = perchance::global().uniform_f32();
```

## Contributing

We welcome community contributions to this project.

Please read our [Contributor Guide](CONTRIBUTING.md) for more information on how to get started.

## License

Licensed under either of

* Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE) or <http://www.apache.org/licenses/LICENSE-2.0>)
* MIT license ([LICENSE-MIT](LICENSE-MIT) or <http://opensource.org/licenses/MIT>)

at your option.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in the work by you, as defined in the Apache-2.0 license, shall be dual licensed as above, without any additional terms or conditions.
