pub use std::io::*;

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        assert_eq!(2 + 2, 4);
    }

    #[test]
    fn test_make_add_functions() {
        let inc = super::make_add_function(1);
        assert_eq!(inc(1), 2);
    }
}


/// create a add function using y as parameter
/// # Example
/// ```
/// use mylib::make_add_function;
/// 
/// let arg = 5;
/// let inc_5 = make_add_function(arg);
/// assert_eq!(6, inc_5(1));
/// ```
pub fn make_add_function(y: i64) -> impl Fn(i64) -> i64 {
    move |x| y+x
}


pub mod kinds {
}


pub mod utils{

}