use std::{net::SocketAddr, path::{Path, PathBuf}};

use penguin::Server;


// ===== Helper stuff ===========================================================================

type Result<T> = std::result::Result<T, Box<dyn std::error::Error>>;

fn addr() -> SocketAddr {
    ([127, 0, 0, 1], 0).into()
}

fn dir(suffix: &str) -> PathBuf {
    let base = std::env::var("CARGO_MANIFEST_DIR").expect("CARGO_MANIFEST_DIR not set");
    Path::new(&base).join("tests").join("files").join(suffix)
}


// ===== Actual tests ===========================================================================

#[tokio::test]
async fn foo() -> Result<()> {
    let (server, _) = Server::bind(addr())
        .add_mount("/", dir("foo"))?
        .build()?;

    tokio::spawn(server);

    Ok(())
}
