use super::Scenario;

/// A scenario that represents an exponential increase in traffic. This represents
/// A*e^(Bx) + C, where x is the time in milisecond
#[allow(non_snake_case)]
#[derive(Clone)]
pub struct ExponentialScenario {
    pub A: f32,
    pub B: f32,
    pub C: f32,
    pub duration: u128,
}

impl Scenario for ExponentialScenario {
    fn rate(&self, time_elasped: std::time::Duration) -> f32 {
        self.A * (self.B * time_elasped.as_millis() as f32).exp() + self.C
    }

    fn duration(&self) -> u128 {
        self.duration
    }

    fn max_rate(&self) -> f32 {
        self.A * (self.B * self.duration as f32).exp() + self.C
    }
}
