---
name: User story
about: New piece of functionality
---

## Rationale

Why are we implementing this feature and what are the key concepts someone must understand to make sense of it.
It's critical that after reading this section the reader understands *why this feature is relevant for business*.

## Description

What the feature actually is, describes in detail the new functionality. Explaining how it should work from a stakeholder point of view.

## Implementation

How is it being implemented, both in terms of UI/UX design and software development.

### UI/UX design

Provide a brief description about the layout expected for this feature and that it's supposed to work.
If possible provide some visual information (eg: mockup using [Balsamiq Wireframes](https://balsamiq.com/wireframes/)).

### Software development

Give references and ideas on how this functionality may be implemented and the code areas that are going to be affected by these changes.

## Reference

Links that might be required to complement some of the information above, which might include documentation or other user stories.

## Estimation

| Discipline | Estimation |
| --- | --- |
| **UI/UX Design** | X days |
| **Software Development** | X days |
