//! # pcomb: parser combinators
//! This is a tiny parser combinator library for rust.
//! Combinators allow the ability to easily compose several parsing functions to
//! produce a larger parser with easy control over output types and control flow.
//! This library can currently statically parse any slice type, including
//! generic ones.
//!
//!
//! See the documentation for the [parse] module to get started.
//! And see the examples folder for a complete parsing example or run
//! `cargo run --example math` inside the project.
//!
//! ## Features
//! This crate defines a few features. All features are enabled by default.
//!
//! - `builtin_parsers`: This feature enables the entire [crate::parsers] module.
//! Your crate should not use this feature if it is not taking advantage of the
//! module.
//! - `std`: This feature enables the use of std. The absence of it enables
//! `#[no_std]`. Note that crate features are additive across all dependencies
//! in your dependency tree, so if other crates dependant on this have std
//! enabled, it will be compiled with std. Note that there are parts of the
//! crate that still require the use of alloc.

#![cfg_attr(not(feature = "std"), no_std)]

pub mod slice;
pub mod parse;

pub use parse::{Parse, ParseError, Empty, Identity, Match};
pub use slice::Slice;

#[cfg(feature = "builtin_parsers")]
pub mod parsers;
