# pcomb: parser combinators

[![repo: sr.ht](https://img.shields.io/badge/repo-sr.ht-blue?style=flat-square)](https://git.sr.ht/~micycle/pcomb)
[![issues: sr.ht](https://img.shields.io/badge/issues-sr.ht-blue?style=flat-square)](https://todo.sr.ht/~micycle/pcomb)
[![patches: sr.ht](https://img.shields.io/badge/patches-sr.ht-blue?style=flat-square)](https://lists.sr.ht/~micycle/public-inbox)

[![crates.io downloads](https://img.shields.io/crates/d/pcomb?style=flat-square)](https://crates.io/crates/pcomb)
[![docs.rs](https://img.shields.io/docsrs/pcomb?style=flat-square)](https://docs.rs/pcomb)
[![license](https://img.shields.io/crates/l/pcomb?style=flat-square)](https://www.gnu.org/licenses/lgpl-3.0.html)
![unsafe: 2](https://img.shields.io/badge/unsafe-2-red?style=flat-square)

This is a tiny parser combinator library for rust.
Combinators allow the ability to easily compose several parsing functions to
produce a larger parser with easy control over output types and control flow.
This library can currently statically parse any slice type, including
generic ones.

See the documentation for [parse] to get started.
And see the examples folder for a complete parsing example or run
`cargo run --example math` inside the project.

## Features
This crate defines a few features. All features are enabled by default.

- `builtin_parsers`: This feature enables the entire [crate::parsers] module.
Your crate should not use this feature if it is not taking advantage of the
module.
- `std`: This feature enables the use of std. The absence of it enables
`#[no_std]`. Note that crate features are additive across all dependencies
in your dependency tree, so if other crates dependant on this have std
enabled, it will be compiled with std. Note that there are parts of the
crate that still require the use of alloc.
