//! # pcomb: *p*arser *comb*inators for the masses
//! This is a tiny parser combinator library for rust.
//! Combinators allow the ability to easily compose several parsing functions to produce a much larger parser with easy control over output types and control flow.
//!
//! At the moment, this library only supports parsing from string slices, and requires that output types support [std::iter::Extend].
//! Crucially, it only allows statically generating combinators via the use of rust's expressive generics. Dynamically composing combinators is in the works, but currently, trait objects do not function.

#![forbid(unsafe_code)]

pub mod str;
pub mod r#dyn;

pub use crate::str::*;

#[cfg(test)]
pub(crate) mod test;
