[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![Coverage Status](https://coveralls.io/repos/github/dsietz/pbd/badge.svg?branch=master)](https://coveralls.io/github/dsietz/pbd?branch=master)
[![Discussions](https://img.shields.io/github/discussions/dsietz/pbd)](https://github.com/dsietz/pbd/discussions)
[![Docs.rs](https://docs.rs/pbd/badge.svg)](https://docs.rs/pbd)

Linux: [![Build Status](https://github.com/dsietz/pbd/workflows/Master/badge.svg)](https://github.com/dsietz/pbd/actions?query=workflow%3AMaster)
Windows: [![Build status](https://ci.appveyor.com/api/projects/status/o3w8863fpji4pfoq?svg=true)](https://ci.appveyor.com/project/dsietz/pbd/branch/master)


# Privacy by Design (PbD) SDK

For software development teams who implement Privacy by Design practices, this PbD SDK provides enablers to help you easily and transparently applying best practices. Unlike other solutions, this SDK maps directly to the Data Privacy strategies to provide a complete tool kit and saves developers time from having to search, derive, or piece together disparate solutions.

---

**Table of Contents**
- [Privacy by Design (PbD) SDK](#privacy-by-design-pbd-sdk)
  - [What's New](#whats-new)
  - [Features](#features)
  - [About](#about)
  - [How to Contribute](#how-to-contribute)
  - [License](#license)

## What's New

Here's whats new in 0.4.1:

We've performed minor upgrades of the versions of our dependencies in order to keep up with their latest versions.

## Features

- Data Usage Agreements (dua)
- Data Tracker Chain (dtc)
- Data Privacy Inspector (dpi)
- Data Security Guard (dsg)

## About

The intent of the `pbd` development kit is to enable the implementation of [privacy design strategies and tactics](./docs/DESIGN-STRATEGIES.md) by providing the functionality and components for developers to implement best practices in their own software soltuions. 

## How to Contribute

Details on how to contribute can be found in the [CONTRIBUTING](./CONTRIBUTING.md) file.

## License

`pbd` is primarily distributed under the terms of the Apache License (Version 2.0).

See [LICENSE-APACHE "Apache License](./LICENSE-APACHE) for details.