use anchor_lang::prelude::*;

pub const SEED_TASK: &[u8] = b"tsk";

#[derive(AnchorSerialize, AnchorDeserialize, Clone, PartialEq)]
pub enum TaskStatus {
    Done,
    Pending,
    Repeat,
}

#[derive(AnchorSerialize, AnchorDeserialize, Clone, Copy, PartialEq)]
pub enum TransferStatus {
    FailedInsufficientDelegateBalance,
    FailedInsufficientBalance,
    FailedNotAuthorized,
    Pending,
    Succeeded,
}

#[account]
pub struct Task {
    pub payment: Pubkey,
    pub process_at: u64,
    pub status: TaskStatus,
    pub transfer_status: TransferStatus,
    pub bump: u8,
}
