use anchor_lang::prelude::*;

pub const SEED_PAYMENT: &[u8] = b"pay";

#[account]
pub struct Payment {
    pub id: u128,                 // The id of the payment.
    pub amount_raw: u64, // The raw amount to transfer. If non-zero, amount_percent must be zero.
    pub amount_percent: u64, // The percentage amount to transfer. If non-zero, amount_raw must be zero. Units of 8
    pub creditor: Pubkey,    // The creditor party to the payment.
    pub creditor_tokens: Pubkey, // The creditor's token account address.
    pub debtor: Pubkey,      // The debtor party to the payment.
    pub debtor_tokens: Pubkey, // The debtor's token account address.
    pub memo: String,        // A memo written by the debtor describing the payment.
    pub mint: Pubkey,        // The mint (currency) token of the payment.
    pub recurrence_interval: u64, // The interval to wait between transfers. If zero, only one transfer will take place.
    pub start_at: u64,            // The time to start the payment at.
    pub end_at: u64, // The time to end the payment at. If recurrence_interval is zero, this must be equal to the start_at.
    pub bump: u8,    // The bump for calculating the PDA.
}
