pub mod errors;
mod instructions;
pub mod state;

use {anchor_lang::prelude::*, instructions::*, state::*};

declare_id!("9gULhYu7k66bNERbo6fX6DqMUYB4JS12MigBWKs3gzVD");

#[program]
pub mod payment_program {
    use crate::state::Role;

    use super::*;

    pub fn initialize_program(
        ctx: Context<InitializeProgram>,
        config_transfer_fee_distributor: u64,
        config_transfer_fee_program: u64,
        authority_bump: u8,
        config_bump: u8,
        treasury_bump: u8,
    ) -> ProgramResult {
        initialize_program::handler(
            ctx,
            config_transfer_fee_distributor,
            config_transfer_fee_program,
            authority_bump,
            config_bump,
            treasury_bump,
        )
    }

    pub fn create_payment(
        ctx: Context<CreatePayment>,
        memo: String,
        amount_raw: u64,
        amount_percent: u64,
        recurrence_interval: u64,
        start_at: u64,
        end_at: u64,
        creditor_payment_pointer_bump: u8,
        creditor_payment_proof_bump: u8,
        debtor_payment_pointer_bump: u8,
        debtor_payment_proof_bump: u8,
        payment_bump: u8,
        task_bump: u8,
        task_pointer_bump: u8,
        task_proof_bump: u8,
    ) -> ProgramResult {
        create_payment::handler(
            ctx,
            memo,
            amount_raw,
            amount_percent,
            recurrence_interval,
            start_at,
            end_at,
            creditor_payment_pointer_bump,
            creditor_payment_proof_bump,
            debtor_payment_pointer_bump,
            debtor_payment_proof_bump,
            payment_bump,
            task_bump,
            task_pointer_bump,
            task_proof_bump,
        )
    }

    pub fn create_task_namespace(
        ctx: Context<CreateTaskNamespace>,
        process_at: u64,
        index_bump: u8,
        namespace_bump: u8,
    ) -> ProgramResult {
        create_task_namespace::handler(ctx, process_at, index_bump, namespace_bump)
    }

    pub fn create_payment_namespace(
        ctx: Context<CreatePaymentNamespace>,
        role: Role,
        index_bump: u8,
        namespace_bump: u8,
    ) -> ProgramResult {
        create_payment_namespace::handler(ctx, role, index_bump, namespace_bump)
    }

    pub fn process_task(ctx: Context<ProcessTask>) -> ProgramResult {
        process_task::handler(ctx)
    }
}
