use anchor_lang::prelude::*;

#[error]
pub enum ErrorCode {
    #[msg("Insufficient SOL to pay transfer fees.")]
    InsufficientBalance,
    #[msg("The timestamps must be chronological.")]
    InvalidChronology,
    #[msg("Recurrence interval must be in units of seconds and divisible by 60.")]
    InvalidRecurrenceInterval,
    #[msg("Task sets cannot be scheduled for processing intra-minute.")]
    InvalidProcessAtIntraMinute,
    #[msg("Task sets cannot be scheduled for processing in the past.")]
    InvalidProcessAtPast,
    #[msg("Task not yet due.")]
    TaskNotDue,
    #[msg("Task must be in a 'pending' state to process")]
    TaskNotPending,

    #[msg("This error does not have a name yet")]
    Unknown,
}
