export type PaymentProgram = {
  "version": "0.1.1",
  "name": "payment_program",
  "instructions": [
    {
      "name": "initializeProgram",
      "accounts": [
        {
          "name": "signer",
          "isMut": true,
          "isSigner": true
        },
        {
          "name": "authority",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "config",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "treasury",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "systemProgram",
          "isMut": false,
          "isSigner": false
        }
      ],
      "args": [
        {
          "name": "configTransferFeeDistributor",
          "type": "u64"
        },
        {
          "name": "configTransferFeeProgram",
          "type": "u64"
        },
        {
          "name": "authorityBump",
          "type": "u8"
        },
        {
          "name": "configBump",
          "type": "u8"
        },
        {
          "name": "treasuryBump",
          "type": "u8"
        }
      ]
    },
    {
      "name": "createPayment",
      "accounts": [
        {
          "name": "authority",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "clock",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "config",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "creditor",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "creditorPaymentIndex",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "creditorPaymentNamespace",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "creditorPaymentPointer",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "creditorPaymentProof",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "creditorTokens",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "debtor",
          "isMut": true,
          "isSigner": true
        },
        {
          "name": "debtorPaymentIndex",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "debtorPaymentNamespace",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "debtorPaymentPointer",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "debtorPaymentProof",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "debtorTokens",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "indexProgram",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "mint",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "payment",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "systemProgram",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "task",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "taskIndex",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "taskNamespace",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "taskPointer",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "taskProof",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "tokenProgram",
          "isMut": false,
          "isSigner": false
        }
      ],
      "args": [
        {
          "name": "memo",
          "type": "string"
        },
        {
          "name": "amountRaw",
          "type": "u64"
        },
        {
          "name": "amountPercent",
          "type": "u64"
        },
        {
          "name": "recurrenceInterval",
          "type": "u64"
        },
        {
          "name": "startAt",
          "type": "u64"
        },
        {
          "name": "endAt",
          "type": "u64"
        },
        {
          "name": "creditorPaymentPointerBump",
          "type": "u8"
        },
        {
          "name": "creditorPaymentProofBump",
          "type": "u8"
        },
        {
          "name": "debtorPaymentPointerBump",
          "type": "u8"
        },
        {
          "name": "debtorPaymentProofBump",
          "type": "u8"
        },
        {
          "name": "paymentBump",
          "type": "u8"
        },
        {
          "name": "taskBump",
          "type": "u8"
        },
        {
          "name": "taskPointerBump",
          "type": "u8"
        },
        {
          "name": "taskProofBump",
          "type": "u8"
        }
      ]
    },
    {
      "name": "createTaskNamespace",
      "accounts": [
        {
          "name": "authority",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "clock",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "index",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "indexProgram",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "namespace",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "payer",
          "isMut": true,
          "isSigner": true
        },
        {
          "name": "systemProgram",
          "isMut": false,
          "isSigner": false
        }
      ],
      "args": [
        {
          "name": "processAt",
          "type": "u64"
        },
        {
          "name": "indexBump",
          "type": "u8"
        },
        {
          "name": "namespaceBump",
          "type": "u8"
        }
      ]
    },
    {
      "name": "createPaymentNamespace",
      "accounts": [
        {
          "name": "authority",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "index",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "indexProgram",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "namespace",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "party",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "payer",
          "isMut": true,
          "isSigner": true
        },
        {
          "name": "systemProgram",
          "isMut": false,
          "isSigner": false
        }
      ],
      "args": [
        {
          "name": "role",
          "type": {
            "defined": "Role"
          }
        },
        {
          "name": "indexBump",
          "type": "u8"
        },
        {
          "name": "namespaceBump",
          "type": "u8"
        }
      ]
    },
    {
      "name": "processTask",
      "accounts": [
        {
          "name": "authority",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "clock",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "config",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "creditorTokens",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "debtorTokens",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "payment",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "signer",
          "isMut": true,
          "isSigner": true
        },
        {
          "name": "systemProgram",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "task",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "treasury",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "tokenProgram",
          "isMut": false,
          "isSigner": false
        }
      ],
      "args": []
    }
  ],
  "accounts": [
    {
      "name": "authority",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "config",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "transferFeeProgram",
            "type": "u64"
          },
          {
            "name": "transferFeeDistributor",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "payment",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "id",
            "type": "u128"
          },
          {
            "name": "amountRaw",
            "type": "u64"
          },
          {
            "name": "amountPercent",
            "type": "u64"
          },
          {
            "name": "creditor",
            "type": "publicKey"
          },
          {
            "name": "creditorTokens",
            "type": "publicKey"
          },
          {
            "name": "debtor",
            "type": "publicKey"
          },
          {
            "name": "debtorTokens",
            "type": "publicKey"
          },
          {
            "name": "memo",
            "type": "string"
          },
          {
            "name": "mint",
            "type": "publicKey"
          },
          {
            "name": "recurrenceInterval",
            "type": "u64"
          },
          {
            "name": "startAt",
            "type": "u64"
          },
          {
            "name": "endAt",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "paymentNamespace",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "party",
            "type": "publicKey"
          },
          {
            "name": "role",
            "type": {
              "defined": "Role"
            }
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "task",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "payment",
            "type": "publicKey"
          },
          {
            "name": "processAt",
            "type": "u64"
          },
          {
            "name": "status",
            "type": {
              "defined": "TaskStatus"
            }
          },
          {
            "name": "transferStatus",
            "type": {
              "defined": "TransferStatus"
            }
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "taskNamespace",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "processAt",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "treasury",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    }
  ],
  "types": [
    {
      "name": "Role",
      "type": {
        "kind": "enum",
        "variants": [
          {
            "name": "Creditor"
          },
          {
            "name": "Debtor"
          }
        ]
      }
    },
    {
      "name": "TaskStatus",
      "type": {
        "kind": "enum",
        "variants": [
          {
            "name": "Done"
          },
          {
            "name": "Pending"
          },
          {
            "name": "Repeat"
          }
        ]
      }
    },
    {
      "name": "TransferStatus",
      "type": {
        "kind": "enum",
        "variants": [
          {
            "name": "FailedInsufficientDelegateBalance"
          },
          {
            "name": "FailedInsufficientBalance"
          },
          {
            "name": "FailedNotAuthorized"
          },
          {
            "name": "Pending"
          },
          {
            "name": "Succeeded"
          }
        ]
      }
    }
  ],
  "errors": [
    {
      "code": 6000,
      "name": "InsufficientBalance",
      "msg": "Insufficient SOL to pay transfer fees."
    },
    {
      "code": 6001,
      "name": "InvalidChronology",
      "msg": "The timestamps must be chronological."
    },
    {
      "code": 6002,
      "name": "InvalidRecurrenceInterval",
      "msg": "Recurrence interval must be in units of seconds and divisible by 60."
    },
    {
      "code": 6003,
      "name": "InvalidProcessAtIntraMinute",
      "msg": "Task sets cannot be scheduled for processing intra-minute."
    },
    {
      "code": 6004,
      "name": "InvalidProcessAtPast",
      "msg": "Task sets cannot be scheduled for processing in the past."
    },
    {
      "code": 6005,
      "name": "TaskNotDue",
      "msg": "Task not yet due."
    },
    {
      "code": 6006,
      "name": "TaskNotPending",
      "msg": "Task must be in a 'pending' state to process"
    },
    {
      "code": 6007,
      "name": "Unknown",
      "msg": "This error does not have a name yet"
    }
  ]
};

export const IDL: PaymentProgram = {
  "version": "0.1.1",
  "name": "payment_program",
  "instructions": [
    {
      "name": "initializeProgram",
      "accounts": [
        {
          "name": "signer",
          "isMut": true,
          "isSigner": true
        },
        {
          "name": "authority",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "config",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "treasury",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "systemProgram",
          "isMut": false,
          "isSigner": false
        }
      ],
      "args": [
        {
          "name": "configTransferFeeDistributor",
          "type": "u64"
        },
        {
          "name": "configTransferFeeProgram",
          "type": "u64"
        },
        {
          "name": "authorityBump",
          "type": "u8"
        },
        {
          "name": "configBump",
          "type": "u8"
        },
        {
          "name": "treasuryBump",
          "type": "u8"
        }
      ]
    },
    {
      "name": "createPayment",
      "accounts": [
        {
          "name": "authority",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "clock",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "config",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "creditor",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "creditorPaymentIndex",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "creditorPaymentNamespace",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "creditorPaymentPointer",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "creditorPaymentProof",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "creditorTokens",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "debtor",
          "isMut": true,
          "isSigner": true
        },
        {
          "name": "debtorPaymentIndex",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "debtorPaymentNamespace",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "debtorPaymentPointer",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "debtorPaymentProof",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "debtorTokens",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "indexProgram",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "mint",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "payment",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "systemProgram",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "task",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "taskIndex",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "taskNamespace",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "taskPointer",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "taskProof",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "tokenProgram",
          "isMut": false,
          "isSigner": false
        }
      ],
      "args": [
        {
          "name": "memo",
          "type": "string"
        },
        {
          "name": "amountRaw",
          "type": "u64"
        },
        {
          "name": "amountPercent",
          "type": "u64"
        },
        {
          "name": "recurrenceInterval",
          "type": "u64"
        },
        {
          "name": "startAt",
          "type": "u64"
        },
        {
          "name": "endAt",
          "type": "u64"
        },
        {
          "name": "creditorPaymentPointerBump",
          "type": "u8"
        },
        {
          "name": "creditorPaymentProofBump",
          "type": "u8"
        },
        {
          "name": "debtorPaymentPointerBump",
          "type": "u8"
        },
        {
          "name": "debtorPaymentProofBump",
          "type": "u8"
        },
        {
          "name": "paymentBump",
          "type": "u8"
        },
        {
          "name": "taskBump",
          "type": "u8"
        },
        {
          "name": "taskPointerBump",
          "type": "u8"
        },
        {
          "name": "taskProofBump",
          "type": "u8"
        }
      ]
    },
    {
      "name": "createTaskNamespace",
      "accounts": [
        {
          "name": "authority",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "clock",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "index",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "indexProgram",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "namespace",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "payer",
          "isMut": true,
          "isSigner": true
        },
        {
          "name": "systemProgram",
          "isMut": false,
          "isSigner": false
        }
      ],
      "args": [
        {
          "name": "processAt",
          "type": "u64"
        },
        {
          "name": "indexBump",
          "type": "u8"
        },
        {
          "name": "namespaceBump",
          "type": "u8"
        }
      ]
    },
    {
      "name": "createPaymentNamespace",
      "accounts": [
        {
          "name": "authority",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "index",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "indexProgram",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "namespace",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "party",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "payer",
          "isMut": true,
          "isSigner": true
        },
        {
          "name": "systemProgram",
          "isMut": false,
          "isSigner": false
        }
      ],
      "args": [
        {
          "name": "role",
          "type": {
            "defined": "Role"
          }
        },
        {
          "name": "indexBump",
          "type": "u8"
        },
        {
          "name": "namespaceBump",
          "type": "u8"
        }
      ]
    },
    {
      "name": "processTask",
      "accounts": [
        {
          "name": "authority",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "clock",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "config",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "creditorTokens",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "debtorTokens",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "payment",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "signer",
          "isMut": true,
          "isSigner": true
        },
        {
          "name": "systemProgram",
          "isMut": false,
          "isSigner": false
        },
        {
          "name": "task",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "treasury",
          "isMut": true,
          "isSigner": false
        },
        {
          "name": "tokenProgram",
          "isMut": false,
          "isSigner": false
        }
      ],
      "args": []
    }
  ],
  "accounts": [
    {
      "name": "authority",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "config",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "transferFeeProgram",
            "type": "u64"
          },
          {
            "name": "transferFeeDistributor",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "payment",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "id",
            "type": "u128"
          },
          {
            "name": "amountRaw",
            "type": "u64"
          },
          {
            "name": "amountPercent",
            "type": "u64"
          },
          {
            "name": "creditor",
            "type": "publicKey"
          },
          {
            "name": "creditorTokens",
            "type": "publicKey"
          },
          {
            "name": "debtor",
            "type": "publicKey"
          },
          {
            "name": "debtorTokens",
            "type": "publicKey"
          },
          {
            "name": "memo",
            "type": "string"
          },
          {
            "name": "mint",
            "type": "publicKey"
          },
          {
            "name": "recurrenceInterval",
            "type": "u64"
          },
          {
            "name": "startAt",
            "type": "u64"
          },
          {
            "name": "endAt",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "paymentNamespace",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "party",
            "type": "publicKey"
          },
          {
            "name": "role",
            "type": {
              "defined": "Role"
            }
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "task",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "payment",
            "type": "publicKey"
          },
          {
            "name": "processAt",
            "type": "u64"
          },
          {
            "name": "status",
            "type": {
              "defined": "TaskStatus"
            }
          },
          {
            "name": "transferStatus",
            "type": {
              "defined": "TransferStatus"
            }
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "taskNamespace",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "processAt",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "treasury",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    }
  ],
  "types": [
    {
      "name": "Role",
      "type": {
        "kind": "enum",
        "variants": [
          {
            "name": "Creditor"
          },
          {
            "name": "Debtor"
          }
        ]
      }
    },
    {
      "name": "TaskStatus",
      "type": {
        "kind": "enum",
        "variants": [
          {
            "name": "Done"
          },
          {
            "name": "Pending"
          },
          {
            "name": "Repeat"
          }
        ]
      }
    },
    {
      "name": "TransferStatus",
      "type": {
        "kind": "enum",
        "variants": [
          {
            "name": "FailedInsufficientDelegateBalance"
          },
          {
            "name": "FailedInsufficientBalance"
          },
          {
            "name": "FailedNotAuthorized"
          },
          {
            "name": "Pending"
          },
          {
            "name": "Succeeded"
          }
        ]
      }
    }
  ],
  "errors": [
    {
      "code": 6000,
      "name": "InsufficientBalance",
      "msg": "Insufficient SOL to pay transfer fees."
    },
    {
      "code": 6001,
      "name": "InvalidChronology",
      "msg": "The timestamps must be chronological."
    },
    {
      "code": 6002,
      "name": "InvalidRecurrenceInterval",
      "msg": "Recurrence interval must be in units of seconds and divisible by 60."
    },
    {
      "code": 6003,
      "name": "InvalidProcessAtIntraMinute",
      "msg": "Task sets cannot be scheduled for processing intra-minute."
    },
    {
      "code": 6004,
      "name": "InvalidProcessAtPast",
      "msg": "Task sets cannot be scheduled for processing in the past."
    },
    {
      "code": 6005,
      "name": "TaskNotDue",
      "msg": "Task not yet due."
    },
    {
      "code": 6006,
      "name": "TaskNotPending",
      "msg": "Task must be in a 'pending' state to process"
    },
    {
      "code": 6007,
      "name": "Unknown",
      "msg": "This error does not have a name yet"
    }
  ]
};
