import { TOKEN_PROGRAM_ID } from "@solana/spl-token";
import {
  PublicKey,
  SystemProgram,
  SYSVAR_CLOCK_PUBKEY,
  TransactionInstruction,
} from "@solana/web3.js";
import * as account from "../account";
import program from "../program";

export type ProcessTaskProps = {
  signer: PublicKey;
  task: PublicKey;
};

export async function processTask({
  signer,
  task,
}: ProcessTaskProps): Promise<TransactionInstruction> {
  // Fetch on-chain data.
  const taskData = await program.account.task.fetch(task);
  const paymentData = await program.account.payment.fetch(taskData.payment);

  const authorityPDA = await account.authority.pda();
  const configPDA = await account.config.pda();
  const treasuryPDA = await account.treasury.pda();

  // Create instruction.
  return program.instruction.processTask({
    accounts: {
      authority: authorityPDA.address,
      clock: SYSVAR_CLOCK_PUBKEY,
      config: configPDA.address,
      creditorTokens: paymentData.creditorTokens,
      debtorTokens: paymentData.debtorTokens,
      payment: taskData.payment,
      signer: signer,
      systemProgram: SystemProgram.programId,
      task: task,
      treasury: treasuryPDA.address,
      tokenProgram: TOKEN_PROGRAM_ID,
    },
  });
}
