import { BN } from "@project-serum/anchor";
import {
  PublicKey,
  SystemProgram,
  TransactionInstruction,
} from "@solana/web3.js";
import * as account from "../account";
import program from "../program";

export type InitializeProgramProps = {
  signer: PublicKey;
  transferFeeDistributor: number;
  transferFeeProgram: number;
};

export async function initializeProgram({
  signer,
  transferFeeDistributor,
  transferFeeProgram,
}: InitializeProgramProps): Promise<TransactionInstruction> {
  const authorityPDA = await account.authority.pda();
  const configPDA = await account.config.pda();
  const treasuryPDA = await account.treasury.pda();
  return program.instruction.initializeProgram(
    new BN(transferFeeDistributor),
    new BN(transferFeeProgram),
    authorityPDA.bump,
    configPDA.bump,
    treasuryPDA.bump,
    {
      accounts: {
        authority: authorityPDA.address,
        config: configPDA.address,
        signer: signer,
        systemProgram: SystemProgram.programId,
        treasury: treasuryPDA.address,
      },
    }
  );
}
