import IndexProgram from "@faktorfi/index-program";
import { dateToSeconds } from "@faktorfi/utils";
import { BN } from "@project-serum/anchor";
import {
  PublicKey,
  SystemProgram,
  SYSVAR_CLOCK_PUBKEY,
  TransactionInstruction,
} from "@solana/web3.js";
import * as account from "../account";
import program from "../program";

export type CreateTaskNamespaceProps = {
  payer: PublicKey;
  processAt: Date;
};

export async function createTaskNamespace({
  payer,
  processAt,
}: CreateTaskNamespaceProps): Promise<TransactionInstruction> {
  // Find namespace PDA.
  const ts = dateToSeconds(processAt);
  const namespacePDA = await account.taskNamespace.pda(ts);

  // Find index PDA.
  const authorityPDA = await account.authority.pda();
  const indexPDA = await IndexProgram.account.index.pda(
    authorityPDA.address,
    namespacePDA.address
  );

  // Create instruction.
  return program.instruction.createTaskNamespace(
    new BN(ts),
    indexPDA.bump,
    namespacePDA.bump,
    {
      accounts: {
        authority: authorityPDA.address,
        clock: SYSVAR_CLOCK_PUBKEY,
        index: indexPDA.address,
        indexProgram: IndexProgram.programId,
        namespace: namespacePDA.address,
        payer: payer,
        systemProgram: SystemProgram.programId,
      },
    }
  );
}
