import IndexProgram from "@faktorfi/index-program";
import {
  PublicKey,
  SystemProgram,
  TransactionInstruction,
} from "@solana/web3.js";
import * as account from "../account";
import program from "../program";
import { Role } from "../enum";

export type CreatePaymentNamespaceProps = {
  party: PublicKey;
  payer: PublicKey;
  role: Role;
};

export async function createPaymentNamespace({
  party,
  payer,
  role,
}: CreatePaymentNamespaceProps): Promise<TransactionInstruction> {
  const authorityPDA = await account.authority.pda();
  const namespacePDA = await account.paymentNamespace.pda(party, role);
  const indexPDA = await IndexProgram.account.index.pda(
    authorityPDA.address,
    namespacePDA.address
  );

  // Create instruction.
  return program.instruction.createPaymentNamespace(
    role,
    indexPDA.bump,
    namespacePDA.bump,
    {
      accounts: {
        authority: authorityPDA.address,
        index: indexPDA.address,
        indexProgram: IndexProgram.programId,
        namespace: namespacePDA.address,
        party: party,
        payer: payer,
        systemProgram: SystemProgram.programId,
      },
    }
  );
}
