export class Role {
  static Creditor = { creditor: {} };
  static Debtor = { debtor: {} };

  public static toString(role: Role): string {
    switch (role) {
      case Role.Creditor:
        return "Creditor";
      case Role.Debtor:
        return "Debtor";
      default:
        throw new Error(`Invalid role: ${role}`);
    }
  }

  public static toBytes(role: Role) {
    return Buffer.from(Role.toString(role));
  }
}
