import { findPDA } from "@faktorfi/utils";
import { PublicKey } from "@solana/web3.js";
import program from "../program";

const SEED_TREASURY = Buffer.from("trs");

export const treasury = {
  fetch: async (addr: PublicKey) => await program.account.treasury.fetch(addr),
  pda: async () => await findPDA([SEED_TREASURY], program.programId),
};
