import { findPDA } from "@faktorfi/utils";
import { PublicKey } from "@solana/web3.js";
import program from "../program";

const SEED_TASK_NAMESPACE = Buffer.from("tsk_ns");

export const taskNamespace = {
  fetch: async (addr: PublicKey) =>
    await program.account.taskNamespace.fetch(addr),
  pda: async (processAt: number) =>
    await findPDA(
      [SEED_TASK_NAMESPACE, Buffer.from(processAt.toString())],
      program.programId
    ),
};
