import { findPDA } from "@faktorfi/utils";
import { PublicKey } from "@solana/web3.js";
import program from "../program";

const SEED_TASK = Buffer.from("tsk");

export const task = {
  fetch: async (addr: PublicKey) => await program.account.task.fetch(addr),
  pda: async (payment: PublicKey, processAt: number) =>
    await findPDA(
      [SEED_TASK, payment.toBuffer(), Buffer.from(processAt.toString())],
      program.programId
    ),
};
