import { findPDA } from "@faktorfi/utils";
import { PublicKey } from "@solana/web3.js";
import { Role } from "../enum";
import program from "../program";

const SEED_PAYMENT_NAMESPACE = Buffer.from("pay_ns");

export const paymentNamespace = {
  fetch: async (addr: PublicKey) =>
    await program.account.paymentNamespace.fetch(addr),
  pda: async (party: PublicKey, role: Role) =>
    await findPDA(
      [SEED_PAYMENT_NAMESPACE, party.toBuffer(), Role.toBytes(role)],
      program.programId
    ),
};
