import { findPDA } from "@faktorfi/utils";
import { BN } from "@project-serum/anchor";
import { PublicKey } from "@solana/web3.js";
import program from "../program";

const SEED_PAYMENT = Buffer.from("pay");

export const payment = {
  fetch: async (addr: PublicKey) => await program.account.payment.fetch(addr),
  pda: async (debtor: PublicKey, id: BN) =>
    await findPDA(
      [SEED_PAYMENT, debtor.toBuffer(), id.toBuffer("be", 16)],
      program.programId
    ),
};
