import { findPDA } from "@faktorfi/utils";
import { PublicKey } from "@solana/web3.js";
import program from "../program";

const SEED_CONFIG = Buffer.from("cfg");

export const config = {
  fetch: async (addr: PublicKey) => await program.account.config.fetch(addr),
  pda: async () => await findPDA([SEED_CONFIG], program.programId),
};
