import { findPDA } from "@faktorfi/utils";
import { PublicKey } from "@solana/web3.js";
import program from "../program";

const SEED_AUTHORITY = Buffer.from("aut");

export const authority = {
  fetch: async (addr: PublicKey) => await program.account.authority.fetch(addr),
  pda: async () => await findPDA([SEED_AUTHORITY], program.programId),
};
