use std::fmt::Display;

pub(crate) fn serialize_i32<S>(v: &i32, ser: S) -> std::result::Result<S::Ok, S::Error>
where
    S: serde::Serializer,
{
    ser.serialize_str(&format!("{v}"))
}

pub(crate) fn serialize_newtype<N: Display, S>(
    v: &N,
    ser: S,
) -> std::result::Result<S::Ok, S::Error>
where
    S: serde::Serializer,
{
    ser.serialize_str(&format!("{v}"))
}

pub(crate) fn serialize_u32<S>(v: &u32, ser: S) -> std::result::Result<S::Ok, S::Error>
where
    S: serde::Serializer,
{
    ser.serialize_str(&format!("{v}"))
}
