/* Copyright (C) 2020 Dylan Staatz - All Rights Reserved. */

use nalgebra::RealField;
use num_traits::{Float, FloatConst};

/// A combination of the RealField trait from nalgebra and Float from num_traits
///
/// The main goal is to provide an interface that can switch between f32 and f64
pub trait Scalar: RealField + Float + FloatConst + Default {}

impl Scalar for f32 {}
impl Scalar for f64 {}
