/* Copyright (C) 2020 Dylan Staatz - All Rights Reserved. */

pub type Result<T> = std::result::Result<T, Error>;

#[derive(thiserror::Error, Debug)]
pub enum Error {
  #[error("Invalid Parameter: {0}")]
  InvalidParamError(#[from] InvalidParamError),
  #[error("I/O Error: {0}")]
  IoError(#[from] std::io::Error),
  #[error("RON Error: {0}")]
  RonError(#[from] ron::Error),
  #[error("Bincode Error: {0}")]
  BincodeError(#[from] bincode::Error),
  #[error("{0}")]
  RunBuildingError(#[from] RunBuildingError),
  #[error("{0}")]
  IndexOutOfBounds(#[from] IndexOutOfBounds),
  #[error("{0}")]
  StatesNotRecorded(#[from] StatesNotRecorded),
  #[error("{0}")]
  RandError(#[from] rand::Error),
  #[error("Failed convex hull operation")]
  ConvexHullError,
  #[error("{0}")]
  TimeError(#[from] time::Error),
  #[error("{0}")]
  CtrlcError(#[from] ctrlc::Error),
  #[error("{0}")]
  KdTreeError(#[from] kdtree::ErrorKind),
  #[error("Strip Prefix Error: {0}")]
  StripPrefixError(#[from] std::path::StripPrefixError),
}

#[derive(thiserror::Error, Debug)]
#[error("Index out of bounds")]
pub struct IndexOutOfBounds;

#[derive(thiserror::Error, Debug)]
#[error("States were not recorded, set keep_in_memory to true or give output directory for states to be saved")]
pub struct StatesNotRecorded;

#[derive(thiserror::Error, Debug)]
#[error("\"{parameter_name}\" was set to \"{parameter_value}\"")]
pub struct InvalidParamError {
  pub parameter_name: &'static str,
  pub parameter_value: String,
}

#[derive(thiserror::Error, Debug)]
pub enum RunBuildingError {
  #[error("Must set parameter_file in builder")]
  ParamsFileNotSet,
}
