/* Copyright (C) 2020 Dylan Staatz - All Rights Reserved. */

pub use crate::cspace::leader_follower::spherical::{D, N};
pub use crate::obstacles::obstacles_3d_f64::*;

////////////////////////////////////////////////////////////////////////////////

use crate::cspace::leader_follower::spherical::*;
use crate::path_planner::RunPathPlanner;
use crate::rrtx::{Rrtx, RrtxState};

pub type CS = LeaderFollowerSphericalSpace<X>;
pub type PP = Rrtx<X, CS, OS, N>;
pub type State = RrtxState<X, CS, OS, N>;

pub type Rrtx3df64DualSpherical = RunPathPlanner<X, CS, OS, PP, N>;
