/* Copyright (C) 2020 Dylan Staatz - All Rights Reserved. */

pub use crate::obstacles::obstacles_3d_f32::*;

////////////////////////////////////////////////////////////////////////////////

use crate::cspace::EuclideanSpace;
use crate::path_planner::RunPathPlanner;
use crate::rrtx::{Rrtx, RrtxState};

pub const N: usize = D;

pub type CS = EuclideanSpace<X, N>;
pub type PP = Rrtx<X, CS, OS, N>;
pub type State = RrtxState<X, CS, OS, N>;

pub type Rrtx3df32 = RunPathPlanner<X, CS, OS, PP, N>;
