/* Copyright (C) 2020 Dylan Staatz - All Rights Reserved. */

pub use crate::obstacles::obstacles_2d_f64::*;

////////////////////////////////////////////////////////////////////////////////

use crate::cspace::leader_follower::LeaderFollowerSpace;
use crate::path_planner::RunPathPlanner;
use crate::rrtx::{Rrtx, RrtxState};

pub const D: usize = 2;
pub const N: usize = D * 2;

pub type CS = LeaderFollowerSpace<X, D, N>;
pub type PP = Rrtx<X, CS, OS, N>;
pub type State = RrtxState<X, CS, OS, N>;

pub type Rrtx2df64Dual = RunPathPlanner<X, CS, OS, PP, N>;
