/* Copyright (C) 2020 Dylan Staatz - All Rights Reserved. */

pub use crate::obstacles::obstacles_2d_f32::*;

////////////////////////////////////////////////////////////////////////////////

use crate::cspace::EuclideanSpace;
use crate::path_planner::RunPathPlanner;
use crate::rrt_star::{RrtStar, RrtStarState};

pub const N: usize = D;

pub type CS = EuclideanSpace<X, N>;
pub type PP = RrtStar<X, CS, OS, N>;
pub type State = RrtStarState<X, CS, OS, N>;

pub type RrtStar2df32 = RunPathPlanner<X, CS, OS, PP, N>;
