/* Copyright (C) 2020 Dylan Staatz - All Rights Reserved. */

pub use crate::obstacles::obstacles_2d_f64::*;

////////////////////////////////////////////////////////////////////////////////

use crate::cspace::EuclideanSpace;
use crate::path_planner::RunPathPlanner;
use crate::rrt::{Rrt, RrtState};

pub const N: usize = D;

pub type CS = EuclideanSpace<X, N>;
pub type PP = Rrt<X, CS, OS, N>;
pub type State = RrtState<X, CS, OS, N>;

pub type Rrt2df64 = RunPathPlanner<X, CS, OS, PP, N>;
