#[test]
fn test_es384_passport() {
	let passport_builder =
		passport::PassportBuilder::new(String::new(), passport::Identity::URI(String::from("owo")))
			.add_destination(passport::Identity::URI(String::from("uwu")))
			.set_expires_in(Some(384));

	let jwt = passport_builder
		.encode(
			&passport::EncodingKey::from_ec_pem(include_bytes!("data/ecdsa-p384-private.pk8"))
				.unwrap(),
			passport::Algorithm::ES384,
		)
		.unwrap();

	let _: jsonwebtoken::TokenData<passport::PassportClaims> = jsonwebtoken::decode(
		jwt.as_str(),
		&jsonwebtoken::DecodingKey::from_ec_pem(include_bytes!("data/ecdsa-p384-public.pk8"))
			.unwrap(),
		&jsonwebtoken::Validation::new(passport::Algorithm::ES384),
	)
	.unwrap();
}
