use std::env;
use std::io;

fn print_entropy(password: &str) {
    println!("{:.2} bits", paspio::get_entropy(password));
}

fn is_all_whitespace(text: &str) -> bool {
    text.as_bytes().iter().all(u8::is_ascii_whitespace)
}

fn get_passwords_from_args() -> Vec<String> {
    let mut args: Vec<String> = env::args().collect();
    args.remove(0);
    return args;
}

fn get_passwords_from_stdin() -> Vec<String> {
    let stdin = io::stdin();
    let mut passwords = vec![];

    loop {
        let mut pass = String::new();

        if let Ok(len) = stdin.read_line(&mut pass) {
            // Break out of loop on Ctrl+D.
            if len == 0 {
                break;
            }

            // Skip over blank lines.
            if is_all_whitespace(&pass) {
                continue;
            }

            passwords.push(pass);
        }
    }

    return passwords;
}

fn main() {
    let mut passwords = get_passwords_from_args();

    if passwords.is_empty() {
        passwords = get_passwords_from_stdin();
    }

    if passwords.is_empty() {
        println!("No passwords provided.");
        return;
    }

    passwords.iter().for_each(|pass| {
        print_entropy(pass);
    })
}
