// Copyright 2021 Ian Jackson and contributors
// SPDX-License-Identifier: GPL-3.0-or-later
// There is NO WARRANTY.

#![feature(exit_status_error)]

use std::env;
use std::fmt;
use std::fs::File;
use std::io::BufRead as _;
use std::io::BufReader;
use std::io::BufWriter;
use std::io::Seek as _;
use std::io::Write as _;
use std::iter;
use std::process::Command;
use std::str;

use either::{Left,Right};
use fehler::{throw, throws};
use indexmap::IndexMap;
use itertools::{chain, Itertools};
use proc_macro2::Span as Span2;
use proc_macro2::TokenStream as TokenStream2;
use proc_macro_error::{abort_call_site, emit_error, proc_macro_error};
use quote::{format_ident, quote, quote_spanned, ToTokens};
use syn::DeriveInput;
use syn::Token;
use syn::parse::{Parse, ParseStream};
use syn::parse_macro_input;

// Namespacing
//
// in parent, for a struct S, we make strut S__Parts and mod S__
//
// generic parameters: we use '__r, _P, _R, _S, _N
//
// in our module, we define
//    F_<field>
// and various fixed names

// Features todo
//    namespace adjustment (see above)
//    PartialBorrow(Debug)
//    impl Deref for Partial<Ref...>
//
// Testing todo
//    Some things that don't compile!: use trybuild

static DEBUG_ENVVAR: &str = "RUST_PARTIAL_BORROW_EXPAND_DEBUG";
static STDERR: &str = "/dev/stderr";

fn default<T:Default>() -> T { Default::default() }

static PERMITS: [&str;3] = ["Not","Ref","Mut"];

mod derive;
mod partial;

#[proc_macro_derive(PartialBorrow)]
pub fn derive(input: proc_macro::TokenStream) -> proc_macro::TokenStream {
  derive::derive(input)
}

#[proc_macro]
pub fn partial(input: proc_macro::TokenStream) -> proc_macro::TokenStream {
  partial::partial(input)
}
