use std::iter::once;

use proc_macro2::TokenStream;
use quote::quote;
use syn::{
	parse_macro_input, Data, DataEnum, DataStruct, DeriveInput, Field, Fields, FieldsNamed,
	FieldsUnnamed,
};

#[proc_macro_derive(Parsable)]
pub fn derive(input: proc_macro::TokenStream) -> proc_macro::TokenStream {
	let DeriveInput {
		attrs,
		vis,
		ident,
		generics,
		data,
	} = parse_macro_input!(input);

	let expression = generate_expression(&data);

	let output = quote! {
		impl<'a> ::parst::Parsable<'a> for #ident #generics {
			fn read(i: &'a [u8]) -> ::parst::PResult<Self> {
				#expression
			}
		}
	};
	proc_macro::TokenStream::from(output)
}

// impl<'a> Parsable<'a> for Test<'a> {
// 	fn read(i: &'a [u8]) -> PResult<Self> {
// 		let (a, i) = Parsable::read(i)?;
// 		let (b, i) = Parsable::read(i)?;
// 		let (c, i) = Parsable::read(i)?;
// 		let (d, i) = Parsable::read(i)?;

// 		Ok((Self { a, b, c, d }, i))
// 	}
// }

fn generate_expression(data: &Data) -> TokenStream {
	match data {
		Data::Struct(DataStruct { fields, .. }) => match fields {
			Fields::Named(FieldsNamed { named, .. }) => {
				let output_inner = fields
					.iter()
					.map(|Field { ident, .. }| {
						let name = ident.as_ref().unwrap();
						quote! { #name, }
					})
					.collect::<TokenStream>();
				let output = quote! {
					Ok((Self { #output_inner }, i))
				};
				named
					.iter()
					.map(|Field { ident, .. }| {
						let name = ident.as_ref().unwrap();
						quote! {
							let (#name, i) = ::parst::Parsable::read(i)?;
						}
					})
					.chain(once(output))
					.collect()
			}
			Fields::Unnamed(FieldsUnnamed { unnamed, .. }) => unnamed
				.iter()
				.map(|field| {
					quote! {}
				})
				.collect(),
			Fields::Unit => {
				quote! {}
			}
		},
		Data::Enum(DataEnum {
			enum_token,
			brace_token,
			variants,
		}) => todo!(),
		Data::Union(_) => unimplemented!(),
	}
}
