## 0.6.4 / 2021-11-21
* Have `ImmutableWikicode` implement `Debug` and `Clone`.

## 0.6.3 / 2021-11-19
* Limit `Section` to those with a `data-mw-section-id` attribute. This fixes a
  panic in `Section::section_id()`. Fixes [#14](https://gitlab.com/mwbot-rs/parsoid/-/issues/14).
* Add convenient `to_mutable()` and `to_immutable()` functions on
  `ImmutableWikicode` and `Wikicode` respectively.

## 0.6.2 / 2021-11-13
* Don't automatically follow redirects, as originally intended. Clients need to
  explicitly follow redirects by checking `get_redirect()`.
* Vary concurrency limit based on rest.php or Restbase. For rest.php the
  concurrency limit is 1, while for Restbase it's 100.

## 0.6.1 / 2021-11-05
* Update to [HTML spec 2.3.0](https://www.mediawiki.org/wiki/Specs/HTML/2.3.0),
  no practical changes for us.
* Add `Wikicode::spec_version()` to get the HTML spec version, if available.
* Rename `Wikicode::title()` to `get_title()`. The old name is still available
  but deprecated.
* Introduce `ImmutableWikicode`, which allows for using `Wikicode` in a
  thread-safe manner.
* Git repository has moved to [https://gitlab.com/mwbot-rs/parsoid](https://gitlab.com/mwbot-rs/parsoid).
* Use `tracing` instead of `log` for logging HTTP requests. Fixes [#11](https://gitlab.com/mwbot-rs/parsoid/-/issues/11).
* Allow using an existing `reqwest::Client` instance when creating a new
  `ParsoidClient`. This will allow sharing connection pools and cookie state
  with other crates making API requests. Fixes [#7](https://gitlab.com/mwbot-rs/parsoid/-/issues/7).

## 0.6.0 / 2021-11-01
* [BREAKING] `Template` no longer has *_on functions for adding it to other
  Wikinodes. Instead, the standard append/prepend/insert_after/insert_before
  functions all support regular Wikinodes and "multi nodes", which include
  templates, noinclude and onlyinclude.
* Document safety expectations and limitations
* Implement `<onlyinclude>` tag support. Document that `<noinclude>` support
  is no longer preliminary.
* Implement support for DisplaySpace nodes, which are added as a
  post-processing step by Parsoid.
* Implement support for Placeholder nodes, which should not be edited by the
  client.
* Implement `<indicator>` tag support.
* Optimize `filter_templates` and `filter_parser_functions`.

## 0.6.0-alpha.3 / 2021-10-20
* The HTTP `Client` now implements `Debug` and `Clone`.
* Client.transform_to_wikitext_raw() now optionally takes a title,
  revision id, and etag, just as transform_to_wikitext() uses.

## 0.6.0-alpha.2 / 2021-10-18
* Implement `<includeonly>` tag support
* Implement preliminary `<noinclude>` tag support
* `filter_comments` is now supported on any Wikinode
* Use [`mwapi_errors`](https://docs.rs/mwapi_errors/0.1) crate for `Error`

## 0.6.0-alpha.1 / 2021-10-13
* Prelude now imports HTTP client as `ParsoidClient` to avoid conflicts with
  other things named `Client`.
* Implement basic concurrency limiting for requests; currently hardcoded to
  10 concurrent requests.

## 0.5.1 / 2021-10-02
* Fix Template.name() for templates with ? in them.
* Improve documentation, including lack of thread-safety
  and internal details about templates' data-mw.
* Switch to using rustls for TLS.
* Update `urlencoding` dependency to 2.1.

## 0.5.0 / 2020-02-20
* [BREAKING] `filter_comments()` now returns `Vec<Comment>`.
* [BREAKING] `Wikicode::new_fragment()` has been replaced by
  `Wikicode::new_node()` and `Wikicode::new_text()`
* [BREAKING] `Heading::new()` takes `&NodeRef` as the second parameter instead
  of a `&str`.
* [BREAKING] `filter_templates()` will only return templates. For parser
  functions use `filter_parser_functions()`.
* [BREAKING] Rename most target/link functions guide people into the
  "pretty" formats by default, providing `raw_` functions if you need it.
* Various link functions take `&NodeRef` as the text parameter.
* Add `Client::get_revision()` to fetch old revisions.
* Mark `Error` as `#[non_exhaustive]`.
* Add request logging using `log`.

## 0.5.0-alpha.1 / 2021-02-11
* [BREAKING] `Template` now represents a list of sibling nodes instead of just one
  * To access the underlying nodes, use `temp.as_nodes()` instead of the now 
    removed `temp.get_node()`. Helpers for most `.attach()`, `.prepend()`, etc.
    operations are available in `Template`.
* [BREAKING] `filter_links()`, `filter_external_links()` now return
  `Vec<Wikinode>`.
* Update to [HTML spec 2.2.0](https://www.mediawiki.org/wiki/Specs/HTML/2.2.0),
  no practical changes for us.
* Make `Wikinode::` ... `prepend()`, `insert_before()`, `insert_after()` usable
* Add `Template::new_simple()` for creation without parameters

## 0.4.2 / 2021-04-07
* Add helpers to get a "pretty" page title for links and templates

## 0.4.1 / 2021-04-06
* Parsoid's `Error` is now available as `parsoid::Error`
* Add specific `Error::PageDoesNotExist` type
* Add specific `Error::InvalidEtag` type

## 0.4.0 / 2021-04-05

* Use dependencies that use Tokio 1.0
* Fix roundtripping of some Cite errors

## 0.3.0-alpha.3 / 2020-11-11
* First usable release
