/*
Copyright (C) 2021 Kunal Mehta <legoktm@debian.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
use serde::{Deserialize, Serialize};

#[derive(Deserialize, Serialize)]
pub(crate) struct IndicatorDataMw {
    pub(crate) name: String,
    pub(crate) attrs: IndicatorAttrs,
    pub(crate) body: IndicatorBody,
}

#[derive(Deserialize, Serialize)]
pub(crate) struct IndicatorAttrs {
    pub(crate) name: String,
}

#[derive(Deserialize, Serialize)]
pub(crate) struct IndicatorBody {
    pub(crate) extsrc: String,
}
