/*
 * Copyright (c) 2020-2021, Arm Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef TS_CRYPTO_OPCODES_H
#define TS_CRYPTO_OPCODES_H

/* C/C++ definition of crypto service opcodes
 */

/* Core operations */
#define TS_CRYPTO_OPCODE_BASE                   (0x0100)
#define TS_CRYPTO_OPCODE_GENERATE_KEY           (TS_CRYPTO_OPCODE_BASE + 1)
#define TS_CRYPTO_OPCODE_DESTROY_KEY            (TS_CRYPTO_OPCODE_BASE + 2)
#define TS_CRYPTO_OPCODE_EXPORT_KEY             (TS_CRYPTO_OPCODE_BASE + 5)
#define TS_CRYPTO_OPCODE_EXPORT_PUBLIC_KEY      (TS_CRYPTO_OPCODE_BASE + 6)
#define TS_CRYPTO_OPCODE_IMPORT_KEY             (TS_CRYPTO_OPCODE_BASE + 7)
#define TS_CRYPTO_OPCODE_SIGN_HASH              (TS_CRYPTO_OPCODE_BASE + 8)
#define TS_CRYPTO_OPCODE_VERIFY_HASH            (TS_CRYPTO_OPCODE_BASE + 9)
#define TS_CRYPTO_OPCODE_ASYMMETRIC_DECRYPT     (TS_CRYPTO_OPCODE_BASE + 10)
#define TS_CRYPTO_OPCODE_ASYMMETRIC_ENCRYPT     (TS_CRYPTO_OPCODE_BASE + 11)
#define TS_CRYPTO_OPCODE_GENERATE_RANDOM        (TS_CRYPTO_OPCODE_BASE + 12)
#define TS_CRYPTO_OPCODE_COPY_KEY               (TS_CRYPTO_OPCODE_BASE + 13)
#define TS_CRYPTO_OPCODE_PURGE_KEY              (TS_CRYPTO_OPCODE_BASE + 14)
#define TS_CRYPTO_OPCODE_GET_KEY_ATTRIBUTES     (TS_CRYPTO_OPCODE_BASE + 15)

/* Hash operations */
#define TS_CRYPTO_OPCODE_HASH_BASE              (0x0200)
#define TS_CRYPTO_OPCODE_HASH_SETUP             (TS_CRYPTO_OPCODE_HASH_BASE + 1)
#define TS_CRYPTO_OPCODE_HASH_UPDATE            (TS_CRYPTO_OPCODE_HASH_BASE + 2)
#define TS_CRYPTO_OPCODE_HASH_FINISH            (TS_CRYPTO_OPCODE_HASH_BASE + 3)
#define TS_CRYPTO_OPCODE_HASH_ABORT             (TS_CRYPTO_OPCODE_HASH_BASE + 4)
#define TS_CRYPTO_OPCODE_HASH_VERIFY            (TS_CRYPTO_OPCODE_HASH_BASE + 5)
#define TS_CRYPTO_OPCODE_HASH_CLONE             (TS_CRYPTO_OPCODE_HASH_BASE + 6)

/* Cipher operations */
#define TS_CRYPTO_OPCODE_CIPHER_BASE            (0x0300)
#define TS_CRYPTO_OPCODE_CIPHER_ENCRYPT_SETUP   (TS_CRYPTO_OPCODE_CIPHER_BASE + 1)
#define TS_CRYPTO_OPCODE_CIPHER_DECRYPT_SETUP   (TS_CRYPTO_OPCODE_CIPHER_BASE + 2)
#define TS_CRYPTO_OPCODE_CIPHER_GENERATE_IV     (TS_CRYPTO_OPCODE_CIPHER_BASE + 3)
#define TS_CRYPTO_OPCODE_CIPHER_SET_IV          (TS_CRYPTO_OPCODE_CIPHER_BASE + 4)
#define TS_CRYPTO_OPCODE_CIPHER_UPDATE          (TS_CRYPTO_OPCODE_CIPHER_BASE + 5)
#define TS_CRYPTO_OPCODE_CIPHER_FINISH          (TS_CRYPTO_OPCODE_CIPHER_BASE + 6)
#define TS_CRYPTO_OPCODE_CIPHER_ABORT           (TS_CRYPTO_OPCODE_CIPHER_BASE + 7)

/* Key derivation operations */
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE                (0x0400)
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_SETUP               (TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE + 1)
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_GET_CAPACITY        (TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE + 2)
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_SET_CAPACITY        (TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE + 3)
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_INPUT_BYTES         (TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE + 4)
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_INPUT_KEY           (TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE + 5)
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_OUTPUT_BYTES        (TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE + 6)
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_OUTPUT_KEY          (TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE + 7)
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_ABORT               (TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE + 8)
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_KEY_AGREEMENT       (TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE + 9)
#define TS_CRYPTO_OPCODE_KEY_DERIVATION_RAW_KEY_AGREEMENT   (TS_CRYPTO_OPCODE_KEY_DERIVATION_BASE + 10)

/* MAC operations */
#define TS_CRYPTO_OPCODE_MAC_BASE               (0x0500)
#define TS_CRYPTO_OPCODE_MAC_SIGN_SETUP         (TS_CRYPTO_OPCODE_MAC_BASE + 1)
#define TS_CRYPTO_OPCODE_MAC_VERIFY_SETUP       (TS_CRYPTO_OPCODE_MAC_BASE + 2)
#define TS_CRYPTO_OPCODE_MAC_UPDATE             (TS_CRYPTO_OPCODE_MAC_BASE + 3)
#define TS_CRYPTO_OPCODE_MAC_SIGN_FINISH        (TS_CRYPTO_OPCODE_MAC_BASE + 4)
#define TS_CRYPTO_OPCODE_MAC_VERIFY_FINISH      (TS_CRYPTO_OPCODE_MAC_BASE + 5)
#define TS_CRYPTO_OPCODE_MAC_ABORT              (TS_CRYPTO_OPCODE_MAC_BASE + 6)

/* AEAD operations */
#define TS_CRYPTO_OPCODE_AEAD_BASE              (0x0600)
#define TS_CRYPTO_OPCODE_AEAD_ENCRYPT_SETUP     (TS_CRYPTO_OPCODE_AEAD_BASE + 1)
#define TS_CRYPTO_OPCODE_AEAD_DECRYPT_SETUP     (TS_CRYPTO_OPCODE_AEAD_BASE + 2)
#define TS_CRYPTO_OPCODE_AEAD_GENERATE_NONCE    (TS_CRYPTO_OPCODE_AEAD_BASE + 3)
#define TS_CRYPTO_OPCODE_AEAD_SET_NONCE         (TS_CRYPTO_OPCODE_AEAD_BASE + 4)
#define TS_CRYPTO_OPCODE_AEAD_SET_LENGTHS       (TS_CRYPTO_OPCODE_AEAD_BASE + 5)
#define TS_CRYPTO_OPCODE_AEAD_UPDATE_AD         (TS_CRYPTO_OPCODE_AEAD_BASE + 6)
#define TS_CRYPTO_OPCODE_AEAD_UPDATE            (TS_CRYPTO_OPCODE_AEAD_BASE + 7)
#define TS_CRYPTO_OPCODE_AEAD_FINISH            (TS_CRYPTO_OPCODE_AEAD_BASE + 8)
#define TS_CRYPTO_OPCODE_AEAD_VERIFY            (TS_CRYPTO_OPCODE_AEAD_BASE + 9)
#define TS_CRYPTO_OPCODE_AEAD_ABORT             (TS_CRYPTO_OPCODE_AEAD_BASE + 10)

#endif /* TS_CRYPTO_OPCODES_H */
