/*
 * Copyright (c) 2021, Arm Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef SPFFA_SERVICE_CONTEXT_H
#define SPFFA_SERVICE_CONTEXT_H

#include <service_locator.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * A service_context that represents a service instance located in
 * a partition, accessed via FFA.  This service_context is suitable
 * for use by client applications running in a secure partition.
 */
struct spffa_service_context
{
	struct service_context service_context;
	uint16_t partition_id;
	uint16_t iface_id;
};

/*
 * Factory method to create a service context associated with the specified
 * partition id and RPC interface instance.
 */
struct spffa_service_context *spffa_service_context_create(
	uint16_t partition_id,
	uint16_t iface_id);

#ifdef __cplusplus
}
#endif

#endif /* SPFFA_SERVICE_CONTEXT_H */
