/*
 * Copyright (c) 2021, Arm Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MOCK_EVENT_LOG_H
#define MOCK_EVENT_LOG_H

#include <stddef.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************************************************
    An event log captured from the TF-A measured boot

    The event log dump that corresponds to the data looks like this:

    NOTICE:  TCG_EfiSpecIDEvent:
    NOTICE:    PCRIndex           : 0
    NOTICE:    EventType          : 3
    NOTICE:    Digest             : 00
    NOTICE:                       : 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
    NOTICE:                       : 00 00 00
    NOTICE:    EventSize          : 33
    NOTICE:    Signature          : Spec ID Event03
    NOTICE:    PlatformClass      : 0
    NOTICE:    SpecVersion        : 2.0.2
    NOTICE:    UintnSize          : 1
    NOTICE:    NumberOfAlgorithms : 1
    NOTICE:    DigestSizes        :
    NOTICE:      #0 AlgorithmId   : SHA256
    NOTICE:         DigestSize    : 32
    NOTICE:    VendorInfoSize     : 0
    NOTICE:  PCR_Event2:
    NOTICE:    PCRIndex           : 0
    NOTICE:    EventType          : 3
    NOTICE:    Digests Count      : 1
    NOTICE:      #0 AlgorithmId   : SHA256
    NOTICE:         Digest        : 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
    NOTICE:                       : 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
    NOTICE:    EventSize          : 17
    NOTICE:    Signature          : StartupLocality
    NOTICE:    StartupLocality    : 0
    NOTICE:  PCR_Event2:
    NOTICE:    PCRIndex           : 0
    NOTICE:    EventType          : 1
    NOTICE:    Digests Count      : 1
    NOTICE:      #0 AlgorithmId   : SHA256
    NOTICE:         Digest        : a8 4f b4 7b 54 d9 4b ab 49 73 63 f7 9b fc 66 cb
    NOTICE:                       : 85 12 ab 18 6f 24 74 01 5d cf 33 f3 80 9e 9b 20
    NOTICE:    EventSize          : 5
    NOTICE:    Event              : BL_2
    NOTICE:  PCR_Event2:
    NOTICE:    PCRIndex           : 0
    NOTICE:    EventType          : 1
    NOTICE:    Digests Count      : 1
    NOTICE:      #0 AlgorithmId   : SHA256
    NOTICE:         Digest        : 2f d3 43 6c 6f ef 9b 11 c2 16 dd 1f 8b df 9b a5
    NOTICE:                       : 24 14 a5 c1 97 0c 3a 6c 78 bf ef 64 0f c1 23 e1
    NOTICE:    EventSize          : 6
    NOTICE:    Event              : BL_31
    NOTICE:  PCR_Event2:
    NOTICE:    PCRIndex           : 0
    NOTICE:    EventType          : 1
    NOTICE:    Digests Count      : 1
    NOTICE:      #0 AlgorithmId   : SHA256
    NOTICE:         Digest        : f3 de 4e 17 a1 a5 a7 fe d9 d9 f4 16 3c 49 36 7e
    NOTICE:                       : ae f7 2f 2a a8 87 e6 b6 22 89 cd 27 dc 1c 80 25
    NOTICE:    EventSize          : 10
    NOTICE:    Event              : HW_CONFIG
    NOTICE:  PCR_Event2:
    NOTICE:    PCRIndex           : 0
    NOTICE:    EventType          : 1
    NOTICE:    Digests Count      : 1
    NOTICE:      #0 AlgorithmId   : SHA256
    NOTICE:         Digest        : 4e e4 8e 5a e6 50 ed e0 b5 a3 54 8a 1f d6 0e 8a
    NOTICE:                       : ea 0e 71 75 0e a4 3f 82 76 ce af cd 7c b0 91 e0
    NOTICE:    EventSize          : 14
    NOTICE:    Event              : SOC_FW_CONFIG
    NOTICE:  PCR_Event2:
    NOTICE:    PCRIndex           : 0
    NOTICE:    EventType          : 1
    NOTICE:    Digests Count      : 1
    NOTICE:      #0 AlgorithmId   : SHA256
    NOTICE:         Digest        : 62 22 4f 0f b0 5d b4 77 1b 3f a5 2e ab 76 1e 61
    NOTICE:                       : 17 b8 c6 6e ac 8c c8 4d 2e b0 7d 70 08 60 4b 41
    NOTICE:    EventSize          : 6
    NOTICE:    Event              : BL_32
    NOTICE:  PCR_Event2:
    NOTICE:    PCRIndex           : 0
    NOTICE:    EventType          : 1
    NOTICE:    Digests Count      : 1
    NOTICE:      #0 AlgorithmId   : SHA256
    NOTICE:         Digest        : 39 d2 b8 5d 93 5d f6 d8 f8 ed 0c 1a 3a e3 c8 90
    NOTICE:                       : 72 19 f4 88 5c 79 15 05 7b f0 76 db c1 4c 5d 77
    NOTICE:    EventSize          : 18
    NOTICE:    Event              : BL32_EXTRA1_IMAGE
    NOTICE:  PCR_Event2:
    NOTICE:    PCRIndex           : 0
    NOTICE:    EventType          : 1
    NOTICE:    Digests Count      : 1
    NOTICE:      #0 AlgorithmId   : SHA256
    NOTICE:         Digest        : b5 d6 08 61 dd fa 6d da a3 f7 a5 de d6 8f 6f 39
    NOTICE:                       : 25 b1 57 fa 3e db 46 42 58 24 8e 81 1c 45 5d 38
    NOTICE:    EventSize          : 6
    NOTICE:    Event              : BL_33
    NOTICE:  PCR_Event2:
    NOTICE:    PCRIndex           : 0
    NOTICE:    EventType          : 1
    NOTICE:    Digests Count      : 1
    NOTICE:      #0 AlgorithmId   : SHA256
    NOTICE:         Digest        : 25 10 60 5d d4 bc 9d 82 7a 16 9f 8a cc 47 95 a6
    NOTICE:                       : fd ca a0 c1 2b c9 99 8f 51 20 ff c6 ed 74 68 5a
    NOTICE:    EventSize          : 13
    NOTICE:    Event              : NT_FW_CONFIG

 ************************************************************************************/
#define MOCK_EVENT_LOG_DATA \
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x21,0x00,0x00,0x00,    \
    0x53,0x70,0x65,0x63,0x20,0x49,0x44,0x20,0x45,0x76,0x65,0x6e,0x74,0x30,0x33,0x00,    \
    0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x01,0x01,0x00,0x00,0x00,0x0b,0x00,0x20,0x00,    \
    0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0b,0x00,0x00,    \
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    \
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,    \
    0x00,0x00,0x00,0x53,0x74,0x61,0x72,0x74,0x75,0x70,0x4c,0x6f,0x63,0x61,0x6c,0x69,    \
    0x74,0x79,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,    \
    0x0b,0x00,0xa8,0x4f,0xb4,0x7b,0x54,0xd9,0x4b,0xab,0x49,0x73,0x63,0xf7,0x9b,0xfc,    \
    0x66,0xcb,0x85,0x12,0xab,0x18,0x6f,0x24,0x74,0x01,0x5d,0xcf,0x33,0xf3,0x80,0x9e,    \
    0x9b,0x20,0x05,0x00,0x00,0x00,0x42,0x4c,0x5f,0x32,0x00,0x00,0x00,0x00,0x00,0x01,    \
    0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0b,0x00,0x2f,0xd3,0x43,0x6c,0x6f,0xef,0x9b,    \
    0x11,0xc2,0x16,0xdd,0x1f,0x8b,0xdf,0x9b,0xa5,0x24,0x14,0xa5,0xc1,0x97,0x0c,0x3a,    \
    0x6c,0x78,0xbf,0xef,0x64,0x0f,0xc1,0x23,0xe1,0x06,0x00,0x00,0x00,0x42,0x4c,0x5f,    \
    0x33,0x31,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0b,    \
    0x00,0xf3,0xde,0x4e,0x17,0xa1,0xa5,0xa7,0xfe,0xd9,0xd9,0xf4,0x16,0x3c,0x49,0x36,    \
    0x7e,0xae,0xf7,0x2f,0x2a,0xa8,0x87,0xe6,0xb6,0x22,0x89,0xcd,0x27,0xdc,0x1c,0x80,    \
    0x25,0x0a,0x00,0x00,0x00,0x48,0x57,0x5f,0x43,0x4f,0x4e,0x46,0x49,0x47,0x00,0x00,    \
    0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0b,0x00,0x4e,0xe4,0x8e,    \
    0x5a,0xe6,0x50,0xed,0xe0,0xb5,0xa3,0x54,0x8a,0x1f,0xd6,0x0e,0x8a,0xea,0x0e,0x71,    \
    0x75,0x0e,0xa4,0x3f,0x82,0x76,0xce,0xaf,0xcd,0x7c,0xb0,0x91,0xe0,0x0e,0x00,0x00,    \
    0x00,0x53,0x4f,0x43,0x5f,0x46,0x57,0x5f,0x43,0x4f,0x4e,0x46,0x49,0x47,0x00,0x00,    \
    0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0b,0x00,0x62,0x22,0x4f,    \
    0x0f,0xb0,0x5d,0xb4,0x77,0x1b,0x3f,0xa5,0x2e,0xab,0x76,0x1e,0x61,0x17,0xb8,0xc6,    \
    0x6e,0xac,0x8c,0xc8,0x4d,0x2e,0xb0,0x7d,0x70,0x08,0x60,0x4b,0x41,0x06,0x00,0x00,    \
    0x00,0x42,0x4c,0x5f,0x33,0x32,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,    \
    0x00,0x00,0x00,0x0b,0x00,0x39,0xd2,0xb8,0x5d,0x93,0x5d,0xf6,0xd8,0xf8,0xed,0x0c,    \
    0x1a,0x3a,0xe3,0xc8,0x90,0x72,0x19,0xf4,0x88,0x5c,0x79,0x15,0x05,0x7b,0xf0,0x76,    \
    0xdb,0xc1,0x4c,0x5d,0x77,0x12,0x00,0x00,0x00,0x42,0x4c,0x33,0x32,0x5f,0x45,0x58,    \
    0x54,0x52,0x41,0x31,0x5f,0x49,0x4d,0x41,0x47,0x45,0x00,0x00,0x00,0x00,0x00,0x01,    \
    0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0b,0x00,0xb5,0xd6,0x08,0x61,0xdd,0xfa,0x6d,    \
    0xda,0xa3,0xf7,0xa5,0xde,0xd6,0x8f,0x6f,0x39,0x25,0xb1,0x57,0xfa,0x3e,0xdb,0x46,    \
    0x42,0x58,0x24,0x8e,0x81,0x1c,0x45,0x5d,0x38,0x06,0x00,0x00,0x00,0x42,0x4c,0x5f,    \
    0x33,0x33,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x0b,    \
    0x00,0x25,0x10,0x60,0x5d,0xd4,0xbc,0x9d,0x82,0x7a,0x16,0x9f,0x8a,0xcc,0x47,0x95,    \
    0xa6,0xfd,0xca,0xa0,0xc1,0x2b,0xc9,0x99,0x8f,0x51,0x20,0xff,0xc6,0xed,0x74,0x68,    \
    0x5a,0x0d,0x00,0x00,0x00,0x4e,0x54,0x5f,0x46,0x57,0x5f,0x43,0x4f,0x4e,0x46,0x49,    \
    0x47,0x00

/* Provides the expected values for a measurement */
struct mock_event_log_measurement
{
    const char *id;
    uint8_t digest[32];
};

/**
 * Returns the start address of the mock event log data
 */
const uint8_t *mock_event_log_start(void);

/**
 * Returns the length mock event log data
 */
size_t mock_event_log_size(void);

/**
 * Returns the expected measurement at the specified index.
 */
const struct mock_event_log_measurement *mock_event_Log_measurement(size_t i);

/**
 * Returns the expected number of measurements.
 */
size_t mock_event_Log_measurement_count(void);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* MOCK_EVENT_LOG_H */
