/*
 * Copyright (c) 2021, Arm Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stddef.h>
#include "mock_event_log.h"

/* Event log data captured from TF-A measured boot */
static const uint8_t mock_event_log[] = {MOCK_EVENT_LOG_DATA};

/* Expected boot measurements for the mock event log*/
static const struct mock_event_log_measurement expected_boot_measurement[] =
{
    {.id = "BL_2",
     .digest = {0xa8,0x4f,0xb4,0x7b,0x54,0xd9,0x4b,0xab,0x49,0x73,0x63,0xf7,0x9b,0xfc,0x66,0xcb,
                0x85,0x12,0xab,0x18,0x6f,0x24,0x74,0x01,0x5d,0xcf,0x33,0xf3,0x80,0x9e,0x9b,0x20}},
    {.id = "BL_31",
     .digest = {0x2f,0xd3,0x43,0x6c,0x6f,0xef,0x9b,0x11,0xc2,0x16,0xdd,0x1f,0x8b,0xdf,0x9b,0xa5,
                0x24,0x14,0xa5,0xc1,0x97,0x0c,0x3a,0x6c,0x78,0xbf,0xef,0x64,0x0f,0xc1,0x23,0xe1}},
    {.id = "HW_CONFIG",
     .digest = {0xf3,0xde,0x4e,0x17,0xa1,0xa5,0xa7,0xfe,0xd9,0xd9,0xf4,0x16,0x3c,0x49,0x36,0x7e,
                0xae,0xf7,0x2f,0x2a,0xa8,0x87,0xe6,0xb6,0x22,0x89,0xcd,0x27,0xdc,0x1c,0x80,0x25}},
    {.id = "SOC_FW_CONFIG",
     .digest = {0x4e,0xe4,0x8e,0x5a,0xe6,0x50,0xed,0xe0,0xb5,0xa3,0x54,0x8a,0x1f,0xd6,0x0e,0x8a,
                0xea,0x0e,0x71,0x75,0x0e,0xa4,0x3f,0x82,0x76,0xce,0xaf,0xcd,0x7c,0xb0,0x91,0xe0}},
    {.id = "BL_32",
     .digest = {0x62,0x22,0x4f,0x0f,0xb0,0x5d,0xb4,0x77,0x1b,0x3f,0xa5,0x2e,0xab,0x76,0x1e,0x61,
                0x17,0xb8,0xc6,0x6e,0xac,0x8c,0xc8,0x4d,0x2e,0xb0,0x7d,0x70,0x08,0x60,0x4b,0x41}},
    {.id = "BL32_EXTRA1_IMAGE",
     .digest = {0x39,0xd2,0xb8,0x5d,0x93,0x5d,0xf6,0xd8,0xf8,0xed,0x0c,0x1a,0x3a,0xe3,0xc8,0x90,
                0x72,0x19,0xf4,0x88,0x5c,0x79,0x15,0x05,0x7b,0xf0,0x76,0xdb,0xc1,0x4c,0x5d,0x77}},
    {.id = "BL_33",
     .digest = {0xb5,0xd6,0x08,0x61,0xdd,0xfa,0x6d,0xda,0xa3,0xf7,0xa5,0xde,0xd6,0x8f,0x6f,0x39,
                0x25,0xb1,0x57,0xfa,0x3e,0xdb,0x46,0x42,0x58,0x24,0x8e,0x81,0x1c,0x45,0x5d,0x38}},
    {.id = "NT_FW_CONFIG",
     .digest = {0x25,0x10,0x60,0x5d,0xd4,0xbc,0x9d,0x82,0x7a,0x16,0x9f,0x8a,0xcc,0x47,0x95,0xa6,
                0xfd,0xca,0xa0,0xc1,0x2b,0xc9,0x99,0x8f,0x51,0x20,0xff,0xc6,0xed,0x74,0x68,0x5a}}
};

const uint8_t *mock_event_log_start(void)
{
    return mock_event_log;
}

size_t mock_event_log_size(void)
{
    return sizeof(mock_event_log);
}

const struct mock_event_log_measurement *mock_event_Log_measurement(size_t i)
{
    const struct mock_event_log_measurement *measurement = NULL;

    if (i < mock_event_Log_measurement_count()) {

        measurement = &expected_boot_measurement[i];
    }

    return measurement;
}

size_t mock_event_Log_measurement_count(void)
{
    return sizeof(expected_boot_measurement)/sizeof(struct mock_event_log_measurement);
}
