# Change Log

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/)
and this project adheres to [Semantic Versioning](http://semver.org/).

Be aware that this project is still v0.y.z which means that anything can change anytime:

>"4. Major version zero (0.y.z) is for initial development. Anything MAY change at any time. The public API SHOULD NOT be considered stable."
>
>(Semantic Versioning Specification)

But we try to mark incompatible changes with a new minor version.

## v0.5.5-pre - unreleased yet

* Better formatting of file paths
* Revived `OwnedToken` type for auto-generation feature of `parol`

## v0.5.4 - 2022-01-08

* As of this version a detailed changelog is maintained to help people to keep track of changes that
have been made since last version of `parol_runtime`.
* A new (non-default) feature `trim_parse_tree` was added. The feature `trim_parse_tree` is useful
if performance is a goal and the full parse tree is not needed at the end of the parse process.
You can activate this feature in your dependencies with this entry

    ```toml
    parol_runtime = { version = "0.5.5", default-features = false, features = ["trim_parse_tree"] }
    ```

    The parse tree returned from `LLKParser::parse` contains only the root node and is therefore
useless if the feature is activated. Also note that you can't access the children of the nodes
provided as parameters of your semantic actions (each of type `&ParseTreeStackEntry`) because they
don't have children anymore. Therefore to navigate them will fail.

    This fixes issue (enhancement) #1
